/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.filetree;

import com.sixthhosp.gcmpa.views.filetree.provider.FileContentProvider;
import com.sixthhosp.gcmpa.views.filetree.provider.FileLabelProvider;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class FileTreeViewer
extends TreeViewer {
    public FileTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new FileContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new FileLabelProvider());
        this.setSorter(new ViewerSorter(){

            public int category(Object element) {
                File file = (File)element;
                if (file.isDirectory()) {
                    return 0;
                }
                return 1;
            }
        });
        this.expandToLevel(1);
    }

    public void openFolder(File folder) {
        this.setExpandedState(folder, true);
    }

    public void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)"Files", (String)message);
    }

    public void showError(String message) {
        MessageDialog.openError((Shell)this.getControl().getShell(), (String)"Files", (String)message);
    }

    public void showWarning(String message) {
        MessageDialog.openWarning((Shell)this.getControl().getShell(), (String)"Files", (String)message);
    }

    public void selectFirtstElement() {
        TreeItem item = this.getTree().getItem(0);
        this.getTree().setSelection(item);
    }
}

