/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.filetree.actions;

import com.sixthhosp.gcmpa.views.filetree.FileTreeViewer;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
extends Action {
    public static final String ID = "eubiosoft.filetree.actions.DeleteAction";
    private FileTreeViewer fileTreeViewer;
    private IStatusLineManager statusline;

    public DeleteAction(FileTreeViewer viewer, IStatusLineManager statusline) {
        this.fileTreeViewer = viewer;
        this.statusline = statusline;
        this.setId(ID);
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setText("Delete");
        this.setToolTipText("Delete Files or Directories");
    }

    public void run() {
        final IStructuredSelection selection = (IStructuredSelection)this.fileTreeViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        File selected_file = (File)selection.getFirstElement();
        String message = selection.size() == 1 ? "Do you really want to delete \"" + selected_file.getName() + "\" ?" : "Do you really want to delete these " + selection.size() + " files or directoies?";
        boolean canDelete = MessageDialog.openQuestion((Shell)this.fileTreeViewer.getTree().getShell(), (String)"Files", (String)message);
        if (!canDelete) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (final File file : selection) {
                    if (file.exists()) {
                        DeleteAction.this.fileTreeViewer.getTree().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                String message = "Delete file or folder: \"" + file.getName() + "\" ...";
                                DeleteAction.this.statusline.setMessage(message);
                            }
                        });
                        boolean isDeleteSuccessed = FileUtils.deleteQuietly((File)file);
                        if (!isDeleteSuccessed) {
                            DeleteAction.this.fileTreeViewer.getTree().getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DeleteAction.this.fileTreeViewer.showError("Delete file or directory \"" + file.getName() + "\" failed.");
                                }
                            });
                        }
                    }
                    DeleteAction.this.fileTreeViewer.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DeleteAction.this.Refresh(file);
                        }
                    });
                }
                DeleteAction.this.fileTreeViewer.getTree().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String message = "Delete file(s) Finished...";
                        DeleteAction.this.statusline.setMessage(message);
                    }
                });
            }
        };
        new Thread(runnable).start();
    }

    private void Refresh(File file) {
        File parentFile = file.getParentFile();
        if (parentFile.exists()) {
            this.fileTreeViewer.refresh(parentFile);
        } else {
            this.Refresh(parentFile);
        }
    }
}

