/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.filetree.actions;

import com.sixthhosp.gcmpa.views.filetree.FileTreeViewer;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.program.Program;

public class OpenAction
extends Action
implements IDoubleClickListener {
    private FileTreeViewer fileTreeViewer;

    public OpenAction(FileTreeViewer viewer) {
        this.fileTreeViewer = viewer;
        this.setText("Open");
        this.setToolTipText("Open the file");
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.fileTreeViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        File file = (File)selection.getFirstElement();
        this.openFile(file);
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        File file = (File)selection.getFirstElement();
        this.openFile(file);
    }

    private void openFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                boolean isOpenSuccessed = Program.launch((String)file.getAbsolutePath());
                if (!isOpenSuccessed) {
                    this.fileTreeViewer.showError("Cann't open the file \"" + file.getName() + "\"");
                }
            } else if (file.isDirectory()) {
                this.fileTreeViewer.openFolder(file);
            }
        } else {
            this.fileTreeViewer.showError("File or directory \"" + file.getName() + "\" has been deleted.");
        }
    }
}

