/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.filetree.provider;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import com.sixthhosp.gcmpa.views.filetree.provider.ResourceManager;
import java.io.File;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class FileLabelProvider
extends LabelProvider {
    private static String defaultFileImagePath = String.valueOf(ConfigFile.getProjectFolderPath()) + "/" + "icons/unknown_file.png";
    private static String defaultFolderImagePath = String.valueOf(ConfigFile.getProjectFolderPath()) + "/" + "icons/directory.png";
    private static Clipboard clipboard;
    private Image defautFileImage = new Image((Device)Display.getCurrent(), defaultFileImagePath);
    private Image defautFolderImage = new Image((Device)Display.getCurrent(), defaultFolderImagePath);

    public Image getImage(Object element) {
        return this.getIcon((File)element);
    }

    public String getText(Object element) {
        String fileName = ((File)element).getName();
        if (fileName.length() > 0) {
            return fileName;
        }
        return ((File)element).getPath();
    }

    private Image getIcon(File file) {
        if (file.isDirectory()) {
            return this.defautFolderImage;
        }
        int lastDotPos = file.getName().lastIndexOf(46);
        if (lastDotPos == -1) {
            return this.defautFileImage;
        }
        Image image = ResourceManager.getIconByExt(file.getName().substring(lastDotPos + 1).toLowerCase());
        return image == null ? this.defautFileImage : image;
    }

    public void dispose() {
        super.dispose();
        this.defautFileImage.dispose();
        this.defautFolderImage.dispose();
    }

    public static String getDefaultFileImagePath() {
        return defaultFileImagePath;
    }

    public static void setDefaultFileImagePath(String defaultFileImagePath) {
        FileLabelProvider.defaultFileImagePath = defaultFileImagePath;
    }

    public static String getDefaultFolderImagePath() {
        return defaultFolderImagePath;
    }

    public static void setDefaultFolderImagePath(String defaultFolderImagePath) {
        FileLabelProvider.defaultFolderImagePath = defaultFolderImagePath;
    }

    public static Clipboard getClipboard() {
        if (clipboard == null) {
            clipboard = new Clipboard(Display.getCurrent());
        }
        return clipboard;
    }
}

