/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.tasktree.actions;

import com.sixthhosp.gcmpa.data.DataFactory;
import com.sixthhosp.gcmpa.tasks.XmlTask;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
extends Action {
    private TableViewer tableViewer;

    public DeleteAction(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.setText("Delete");
        this.setToolTipText("Delete the selected task");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE_DISABLED"));
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object instanceof XmlTask) {
            XmlTask xmlTask = (XmlTask)object;
            if (xmlTask.isAllFinished()) {
                String message = "Do you really want to delete task \"" + xmlTask.getTaskname() + "\" ?";
                boolean canDelete = MessageDialog.openQuestion((Shell)this.tableViewer.getTable().getShell(), (String)"Confirm", (String)message);
                if (canDelete) {
                    DataFactory.getTaskBox().delete(xmlTask);
                    this.tableViewer.refresh();
                    DataFactory.saveTaskBox();
                }
            } else {
                return;
            }
        }
    }
}

