/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.tasktree.actions;

import com.sixthhosp.gcmpa.editors.ei.LogEditorInput;
import com.sixthhosp.gcmpa.tasks.XmlTask;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenLogAction
extends Action {
    private TableViewer tableViewer;

    public OpenLogAction(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.setText("View Log");
        this.setToolTipText("View the selected task's log");
        this.setImageDescriptor(ImageDescriptor.createFromFile(OpenLogAction.class, (String)"icons/logs.gif"));
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object instanceof XmlTask) {
            XmlTask xmlTask = (XmlTask)object;
            if (xmlTask.isAllFinished()) {
                try {
                    LogEditorInput logEditorInput = new LogEditorInput(xmlTask);
                    IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    workbenchPage.openEditor((IEditorInput)logEditorInput, "com.sixthhosp.gcmpa.editors.logditor");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            } else {
                return;
            }
        }
    }
}

