/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.tasktree.actions;

import com.sixthhosp.gcmpa.editors.ei.HtmlEditorInput;
import com.sixthhosp.gcmpa.editors.ei.LogEditorInput;
import com.sixthhosp.gcmpa.tasks.XmlTask;
import com.sixthhosp.gcmpa.views.filetree.FileTreeViewer;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenResultAction
extends Action
implements IDoubleClickListener {
    private TableViewer tableViewer;
    private TreeViewer treeViewer;

    public OpenResultAction(TableViewer tableViewer, FileTreeViewer fileTreeViewer) {
        this.treeViewer = fileTreeViewer;
        this.tableViewer = tableViewer;
        this.setText("Open Result");
        this.setToolTipText("Open the selected task result");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object object = selection.getFirstElement();
        if (!(object instanceof XmlTask)) return;
        XmlTask xmlTask = (XmlTask)object;
        if (xmlTask.isAllFinished() && xmlTask.getTaskstate().equals("Finished")) {
            if (new File(xmlTask.getHtmloutpath()).exists()) {
                HtmlEditorInput htmlEditorInput = new HtmlEditorInput(xmlTask);
                IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    workbenchPage.openEditor((IEditorInput)htmlEditorInput, "com.sixthhosp.gcmpa.editors.htmleditor");
                    this.treeViewer.setInput((Object)new File(xmlTask.getHtmloutpath()).getParentFile());
                    return;
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
                return;
            }
            this.treeViewer.setInput(null);
            MessageDialog.openError((Shell)this.tableViewer.getTable().getShell(), (String)("Error in task: " + xmlTask.getTaskname()), (String)"The output file is not exist!");
            return;
        }
        if (!xmlTask.isAllFinished() || !xmlTask.getTaskstate().equals("Failed") && !xmlTask.getTaskstate().equals("Terminated")) return;
        try {
            LogEditorInput logEditorInput = new LogEditorInput(xmlTask);
            IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            workbenchPage.openEditor((IEditorInput)logEditorInput, "com.sixthhosp.gcmpa.editors.logditor");
            return;
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.run();
    }
}

