/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.tasktree.actions;

import com.sixthhosp.gcmpa.tasks.XmlTask;
import com.sixthhosp.gcmpa.views.tasktree.actions.OpenFileUtils;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenResultFolderAction
extends Action
implements IDoubleClickListener {
    private TableViewer tableViewer;

    public OpenResultFolderAction(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.setText("Open Result Folder in OS Explorer");
        this.setToolTipText("Open the selected task result folder");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
    }

    public void run() {
        XmlTask xmlTask;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object instanceof XmlTask && (xmlTask = (XmlTask)object).isAllFinished() && xmlTask.getTaskstate().equals("Finished")) {
            if (new File(xmlTask.getOutputsfolderpath()).exists()) {
                try {
                    OpenFileUtils.opneFile(new File(xmlTask.getOutputsfolderpath()));
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)this.tableViewer.getTable().getShell(), (String)"Error", (String)e.getMessage());
                }
            } else {
                MessageDialog.openError((Shell)this.tableViewer.getTable().getShell(), (String)("Error in task: " + xmlTask.getTaskname()), (String)"The output folder is not exist!");
                return;
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.run();
    }
}

