/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.tasktree.actions;

import com.sixthhosp.gcmpa.editors.ei.ParamEditorInput;
import com.sixthhosp.gcmpa.tasks.XmlTask;
import com.sixthhosp.gcmpa.tools.Tool;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolDocument;
import com.sixthhosp.gcmpa.xmlbeans.tool.ToolType;
import java.io.File;
import java.io.IOException;
import org.apache.xmlbeans.XmlException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ReRunAction
extends Action {
    private TableViewer tableViewer;

    public ReRunAction(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.setText("ReRun");
        this.setToolTipText("ReRun the selected task");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ReRunAction.class, (String)"icons/Rotate360AntiClockwise2Red.png"));
    }

    public void run() {
        block5: {
            IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
            if (selection.size() != 1) {
                return;
            }
            Object object = selection.getFirstElement();
            if (object instanceof XmlTask) {
                try {
                    XmlTask xmlTask = (XmlTask)object;
                    String xmlFilePath = xmlTask.getXmlinfopath();
                    File xmlFile = new File(xmlFilePath);
                    if (!xmlTask.isAllFinished()) break block5;
                    if (xmlFile.exists()) {
                        ToolDocument toolDocument = ToolDocument.Factory.parse((File)xmlFile);
                        ToolType toolType = toolDocument.getTool();
                        Tool tool = new Tool(toolType, xmlFilePath);
                        ParamEditorInput paramEditorInput = new ParamEditorInput(tool);
                        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        workbenchPage.openEditor((IEditorInput)paramEditorInput, "com.sixthhosp.gcmpa.editors.parameditor");
                        break block5;
                    }
                    MessageDialog.openError((Shell)this.tableViewer.getTable().getShell(), (String)("Error in task: " + xmlTask.getTaskname()), (String)"The param config file is not exist!");
                    return;
                }
                catch (IOException | XmlException | PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

