/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.tooltree.actions;

import com.sixthhosp.gcmpa.editors.ei.HelpEditorInput;
import com.sixthhosp.gcmpa.tools.Tool;
import com.sixthhosp.gcmpa.tools.ToolSection;
import com.sixthhosp.gcmpa.tools.ToolSectionLabel;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenHelpAction
extends Action {
    public static final String ID = "eubiosoft.tooltree.actions.OpenHelpAction";
    private TreeViewer treeViewer;

    public OpenHelpAction(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.setText("Open Help");
        this.setToolTipText("Open the selected tool help document");
        this.setImageDescriptor(ImageDescriptor.createFromFile(OpenHelpAction.class, (String)"icons/help_contents(1).gif"));
        this.setDisabledImageDescriptor(ImageDescriptor.createFromFile(OpenHelpAction.class, (String)"icons/help_contents.gif"));
        this.setId(ID);
        this.setActionDefinitionId("com.sixthhosp.gcmpa.toolhelp");
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object instanceof ToolSectionLabel) {
            return;
        }
        if (object instanceof ToolSection) {
            return;
        }
        if (object instanceof Tool) {
            Tool tool = (Tool)object;
            String helpPath = tool.getHelpPath();
            if (StringUtils.isNotBlank((String)helpPath) && new File(helpPath).exists()) {
                HelpEditorInput helpEditorInput = new HelpEditorInput(tool);
                IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = workbenchPage.findEditor((IEditorInput)helpEditorInput);
                if (editor != null) {
                    workbenchPage.bringToTop((IWorkbenchPart)editor);
                } else {
                    try {
                        workbenchPage.openEditor((IEditorInput)helpEditorInput, "com.sixthhosp.gcmpa.editors.helpeditor");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Shell shell = this.treeViewer.getTree().getShell();
                MessageDialog.openError((Shell)shell, (String)tool.getName(), (String)"No Tool Help Document");
            }
        }
    }
}

