/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.tooltree.actions;

import com.sixthhosp.gcmpa.editors.ei.ParamEditorInput;
import com.sixthhosp.gcmpa.tools.Tool;
import com.sixthhosp.gcmpa.tools.ToolSection;
import com.sixthhosp.gcmpa.tools.ToolSectionLabel;
import com.sixthhosp.gcmpa.tools.Utils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenToolAction
extends Action
implements IDoubleClickListener {
    private TreeViewer toolTreeViewer;

    public OpenToolAction(TreeViewer toolTreeViewer) {
        this.toolTreeViewer = toolTreeViewer;
        this.setText("Open Tool");
        this.setToolTipText("Open the selected tool");
        this.setImageDescriptor(ImageDescriptor.createFromFile(OpenToolAction.class, (String)"icons/run_tool(1).gif"));
        this.setDisabledImageDescriptor(ImageDescriptor.createFromFile(OpenToolAction.class, (String)"icons/run_tool.gif"));
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.toolTreeViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object instanceof ToolSectionLabel) {
            return;
        }
        if (object instanceof ToolSection) {
            this.toolTreeViewer.setExpandedState(object, !this.toolTreeViewer.getExpandedState(object));
            return;
        }
        if (object instanceof Tool) {
            Tool tool = (Tool)object;
            try {
                Utils.validateToolXML(tool.getFilePath());
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.toolTreeViewer.getTree().getShell(), (String)("Error in tool: " + tool.getName()), (String)e.getMessage());
                return;
            }
            ParamEditorInput paramEditorInput = new ParamEditorInput(tool);
            IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                workbenchPage.openEditor((IEditorInput)paramEditorInput, "com.sixthhosp.gcmpa.editors.parameditor");
            }
            catch (PartInitException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.run();
    }
}

