/*
 * Decompiled with CFR 0.152.
 */
package com.sixthhosp.gcmpa.views.tooltree.provider;

import com.sixthhosp.gcmpa.configs.ConfigFile;
import com.sixthhosp.gcmpa.tools.Tool;
import com.sixthhosp.gcmpa.tools.ToolSection;
import com.sixthhosp.gcmpa.tools.ToolSectionLabel;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ToolLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    private static String defaultToolImagePath = String.valueOf(ConfigFile.getProjectFolderPath()) + "/" + "icons/toolico.gif";
    private static String defaultSectionImagePath = String.valueOf(ConfigFile.getProjectFolderPath()) + "/" + "icons/flatLayout(3).gif";
    private ArrayList<Image> images = new ArrayList();
    private Image defaultToolImage = new Image((Device)Display.getCurrent(), defaultToolImagePath);
    private Image defaultSectionImage = new Image((Device)Display.getCurrent(), defaultSectionImagePath);
    private Font toolFont;

    public ToolLabelProvider() {
        FontData[] toolFontDatas;
        FontData[] fontDataArray = toolFontDatas = Display.getCurrent().getSystemFont().getFontData();
        int n = toolFontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setStyle(1);
            ++n2;
        }
        this.toolFont = new Font((Device)Display.getCurrent(), toolFontDatas);
    }

    public void update(ViewerCell cell) {
        Object object = cell.getElement();
        if (object instanceof ToolSectionLabel) {
            ToolSectionLabel toolSectionLabel = (ToolSectionLabel)object;
            String label = toolSectionLabel.getText();
            cell.setText(label);
            cell.setForeground(this.getViewer().getControl().getDisplay().getSystemColor(6));
            cell.setFont(this.toolFont);
        } else if (object instanceof Tool) {
            Tool tool = (Tool)object;
            String name = tool.getName();
            String description = tool.getDescription();
            String string = description != null ? String.valueOf(name) + " " + description : name;
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = name.length();
            styleRange.font = this.toolFont;
            StyleRange[] styleRanges = new StyleRange[]{styleRange};
            cell.setText(string);
            cell.setStyleRanges(styleRanges);
            String iconPath = tool.getIconPath();
            if (StringUtils.isNotBlank((String)iconPath) && new File(iconPath).exists()) {
                Image image = new Image((Device)Display.getCurrent(), iconPath);
                this.images.add(image);
                cell.setImage(image);
            } else {
                cell.setImage(this.defaultToolImage);
            }
        } else if (object instanceof ToolSection) {
            ToolSection toolSection = (ToolSection)object;
            String name = toolSection.getName();
            cell.setText(name);
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = name.length();
            styleRange.underline = true;
            StyleRange[] styleRanges = new StyleRange[]{styleRange};
            cell.setStyleRanges(styleRanges);
            String icon = toolSection.getIcon();
            String iconPath = String.valueOf(ConfigFile.getSoftFolderPath()) + "/" + icon;
            if (icon != null && new File(iconPath).exists()) {
                Image image = new Image((Device)Display.getCurrent(), iconPath);
                this.images.add(image);
                cell.setImage(image);
            } else {
                cell.setImage(this.defaultSectionImage);
            }
        }
        super.update(cell);
    }

    public void dispose() {
        super.dispose();
        for (Image image : this.images) {
            image.dispose();
        }
        this.defaultToolImage.dispose();
        this.defaultSectionImage.dispose();
        this.toolFont.dispose();
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ToolSectionLabel) {
            ToolSectionLabel toolSectionLabel = (ToolSectionLabel)element;
            return toolSectionLabel.getText();
        }
        if (element instanceof Tool) {
            Tool tool = (Tool)element;
            String description = tool.getDescription();
            String string = description != null ? String.valueOf(tool.getName()) + " " + description : tool.getName();
            return string;
        }
        if (element instanceof ToolSection) {
            ToolSection toolSection = (ToolSection)element;
            return toolSection.getName();
        }
        return null;
    }

    public static String getDefaultToolImagePath() {
        return defaultToolImagePath;
    }

    public static void setDefaultToolImagePath(String defaultToolImagePath) {
        ToolLabelProvider.defaultToolImagePath = defaultToolImagePath;
    }

    public static String getDefaultSectionImagePath() {
        return defaultSectionImagePath;
    }

    public static void setDefaultSectionImagePath(String defaultSectionImagePath) {
        ToolLabelProvider.defaultSectionImagePath = defaultSectionImagePath;
    }
}

