/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.attributes;

import com.jrockit.mc.common.debug.Debug;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.common.util.ExceptionToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ConnectionClosedException;
import com.jrockit.mc.rjmx.services.IAttributeInfo;
import com.jrockit.mc.rjmx.services.IUpdateInterval;
import com.jrockit.mc.rjmx.services.ServiceNotAvailableException;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValue;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.subscription.internal.UpdatePolicyToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.attributes.Messages;
import com.jrockit.mc.rjmx.util.internal.AbstractReadOnlyAttribute;
import com.jrockit.mc.rjmx.util.internal.PartitionedList;
import com.jrockit.mc.rjmx.util.internal.SimpleAttributeInfo;
import java.rmi.UnmarshalException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;

public class ReadOnlyMRIAttribute
extends AbstractReadOnlyAttribute
implements IUpdateInterval,
IAdaptable {
    private static final int MAX_TRACE_FRAMES_IN_MESSAGE = 5;
    private final IConnectionHandle m_handle;
    private final MRI m_mri;
    private Object m_value;
    private String m_refreshProblem = null;

    protected ReadOnlyMRIAttribute(IConnectionHandle handle, MRI mri) {
        this(handle, mri, null);
    }

    public ReadOnlyMRIAttribute(IConnectionHandle handle, MRI mri, Object value) {
        super((IAttributeInfo)new SimpleAttributeInfo(ReadOnlyMRIAttribute.extractName(mri.getDataPath()), MRIMetaDataToolkit.getAttributeInfo((IConnectionHandle)handle, (MRI)mri).getValueType()));
        this.m_handle = handle;
        this.m_mri = mri;
        this.m_value = value;
    }

    private static String extractName(String dataPath) {
        if (dataPath == null) {
            return "[null]";
        }
        int index = dataPath.lastIndexOf(47);
        if (index >= 0) {
            return String.valueOf('#') + dataPath.substring(index + 1);
        }
        return dataPath;
    }

    public boolean hasChildren() {
        if (this.getValue() instanceof CompositeData) {
            return !((CompositeData)this.getValue()).getCompositeType().keySet().isEmpty();
        }
        return super.hasChildren();
    }

    public Collection<?> getChildren() {
        if (this.getValue() instanceof CompositeData) {
            return this.getMRICompositeChildren((CompositeData)this.getValue());
        }
        return super.getChildren();
    }

    private Collection<?> getMRICompositeChildren(CompositeData compositeDataValue) {
        IConnectionHandle handle = this.getHandle();
        MRI baseMRI = this.getMRI();
        ArrayList<ReadOnlyMRIAttribute> elements = new ArrayList<ReadOnlyMRIAttribute>();
        for (String key : compositeDataValue.getCompositeType().keySet()) {
            elements.add(new ReadOnlyMRIAttribute(handle, new MRI(baseMRI, key), compositeDataValue.get(key)));
        }
        return PartitionedList.create(elements);
    }

    public boolean refresh() {
        Object newValue;
        block10: {
            newValue = null;
            MRIValue attribute = this.getMBeanHelperService().getAttribute(this.m_mri);
            if (attribute != null) {
                newValue = attribute.getValue();
            }
            if (!(this.m_value == null ? newValue == null : this.m_value.equals(newValue))) break block10;
            return false;
        }
        try {
            this.m_refreshProblem = null;
            this.m_value = newValue;
            return true;
        }
        catch (ConnectionClosedException e) {
            this.m_refreshProblem = Messages.ReadOnlyMRIAttribute_PROBLEM_CONNECTION_CLOSED;
            RJMXUIPlugin.getDefault().getLogger().log(Level.INFO, "Could not refresh ReadOnlyMRIAttribute since the connection was closed");
        }
        catch (UnmarshalException e) {
            this.m_refreshProblem = String.valueOf(NLS.bind((String)Messages.ReadOnlyMRIAttribute_PROBLEM_UNMARSHAL, (Object)this.getMRI().getDataPath())) + "\n" + e.getMessage();
            if (Debug.isDebug()) {
                RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Could not unmarshal the value for attribute {0}: {1}", this.getMRI().getDataPath(), e.getMessage()), e);
            }
        }
        catch (MBeanException e) {
            Throwable cause = ReadOnlyMRIAttribute.unmarshalMBeanException(e);
            this.m_refreshProblem = String.valueOf(NLS.bind((String)Messages.ReadOnlyMRIAttribute_PROBLEM_SERVER, (Object)this.getMRI().getDataPath())) + "\n" + ExceptionToolkit.toString((Throwable)cause, (int)5);
            if (Debug.isDebug()) {
                RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Server error getting attribute {0}: {1}", this.getMRI().getDataPath(), cause), cause);
            }
        }
        catch (AttributeNotFoundException e) {
            this.m_refreshProblem = NLS.bind((String)Messages.ReadOnlyMRIAttribute_PROBLEM_ATTRIBUTE_NOT_FOUND, (Object)this.getMRI().getDataPath());
            RJMXUIPlugin.getDefault().getLogger().log(Level.INFO, MessageFormat.format("Error getting attribute {0}: {1}", this.getMRI().getDataPath(), e.getMessage()));
        }
        catch (Exception e) {
            this.m_refreshProblem = String.valueOf(NLS.bind((String)Messages.ReadOnlyMRIAttribute_PROBLEM_EXCEPTION, (Object)this.getMRI().getDataPath(), (Object)e.getMessage())) + "\n" + Messages.ReadOnlyMRIAttribute_STACK_TRACE_IN_LOG;
            RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Error getting attribute {0}: {1}", this.getMRI().getDataPath(), e.getMessage()), e);
        }
        this.m_value = MRIValue.UNAVAILABLE_VALUE;
        return false;
    }

    public Object getValue() {
        return this.m_value;
    }

    protected IMBeanHelperService getMBeanHelperService() throws ConnectionClosedException, ServiceNotAvailableException {
        return (IMBeanHelperService)this.m_handle.getServiceOrThrow(IMBeanHelperService.class);
    }

    public void updateValue(Object value) {
        this.m_value = value;
    }

    public MRI getMRI() {
        return this.m_mri;
    }

    public IUnit<?> getUnit() {
        return UnitLookup.getUnitOrNull((String)AttributeToolkit.getUnitString((IConnectionHandle)this.m_handle, (MRI)this.m_mri));
    }

    protected IConnectionHandle getHandle() {
        return this.m_handle;
    }

    public int getUpdateInterval() {
        return UpdatePolicyToolkit.getUpdateInterval((IConnectionHandle)this.m_handle, (MRI)this.m_mri);
    }

    public void setUpdateInterval(int interval) {
        UpdatePolicyToolkit.setUpdatePolicy((IConnectionHandle)this.m_handle, (MRI)this.m_mri, (IUpdatePolicy)UpdatePolicyToolkit.getUpdatePolicy((int)interval));
    }

    public boolean equals(Object that) {
        return that instanceof ReadOnlyMRIAttribute ? this.getMRI().equals((Object)((ReadOnlyMRIAttribute)((Object)that)).getMRI()) : false;
    }

    public int hashCode() {
        return this.getMRI().hashCode();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + '{' + this.getMRI() + ',' + this.getValue() + '}';
    }

    public static void refresh(IConnectionHandle connection, Map<MRI, ReadOnlyMRIAttribute> attributeMap) {
        try {
            List values = ((IMBeanHelperService)connection.getServiceOrThrow(IMBeanHelperService.class)).getAttributes(attributeMap.keySet());
            for (MRIValue value : values) {
                attributeMap.remove(value.getMRI()).updateValue(value.getValue());
            }
        }
        catch (ConnectionClosedException e) {
            RJMXUIPlugin.getDefault().getLogger().log(Level.INFO, "Could not refresh attributes since the connection was closed");
            return;
        }
        catch (MBeanException e) {
            Throwable cause = ReadOnlyMRIAttribute.unmarshalMBeanException(e);
            RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Server error getting attributes: " + cause.getMessage());
        }
        catch (Exception e) {
            RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Error getting attributes: " + e.getMessage());
        }
        for (ReadOnlyMRIAttribute attribute : attributeMap.values()) {
            attribute.refresh();
        }
    }

    private static Throwable unmarshalMBeanException(MBeanException e) {
        Throwable cause = e.getTargetException();
        if (cause instanceof RuntimeErrorException) {
            cause = ((RuntimeErrorException)cause).getTargetError();
        } else if (cause instanceof RuntimeMBeanException) {
            cause = ((RuntimeMBeanException)cause).getTargetException();
        }
        return cause;
    }

    public String getRefreshProblem() {
        return this.m_refreshProblem;
    }

    public Object getAdapter(Class adapter) {
        return MRI.class.equals((Object)adapter) ? this.m_mri : null;
    }
}

